<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h4 class="no-margin">
                                    <i class="fa fa-wrench"></i> 
                                    <?php echo $title; ?>
                                </h4>
                            </div>
                            <div class="col-md-4 text-right">
                                <a href="<?php echo admin_url('workshop/reports'); ?>" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> <?php echo _l('back'); ?>
                                </a>
                            </div>
                        </div>
                        <hr class="hr-panel-heading" />

                        <!-- Statistics Cards -->
                        <div class="row">
                            <div class="col-md-3">
                                <div class="panel panel-primary">
                                    <div class="panel-body text-center">
                                        <h3 class="bold text-primary"><?php echo $stats['total']; ?></h3>
                                        <p>Всего заявок</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="panel panel-warning">
                                    <div class="panel-body text-center">
                                        <h3 class="bold text-warning"><?php echo $stats['pending']; ?></h3>
                                        <p>Ожидание / Забронировано</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="panel panel-info">
                                    <div class="panel-body text-center">
                                        <h3 class="bold text-info"><?php echo $stats['in_progress']; ?></h3>
                                        <p>В работе</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="panel panel-success">
                                    <div class="panel-body text-center">
                                        <h3 class="bold text-success"><?php echo $stats['completed']; ?></h3>
                                        <p>Завершено / Финализировано</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Additional Stats -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="panel panel-default">
                                    <div class="panel-body text-center">
                                        <h3 class="bold"><?php echo app_format_money($stats['total_revenue'], ''); ?></h3>
                                        <p>Общая выручка</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="panel panel-default">
                                    <div class="panel-body text-center">
                                        <h3 class="bold"><?php echo number_format($stats['total_hours'], 1); ?> ч.</h3>
                                        <p>Общее время работ</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Filters -->
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <i class="fa fa-filter"></i> <?php echo _l('filter'); ?>
                            </div>
                            <div class="panel-body">
                                <?php echo form_open(admin_url('workshop/report_repair_jobs'), ['method' => 'get']); ?>
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Дата с</label>
                                            <?php echo render_date_input('date_from', '', isset($filters['date_from']) ? $filters['date_from'] : date('Y-m-01')); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Дата по</label>
                                            <?php echo render_date_input('date_to', '', isset($filters['date_to']) ? $filters['date_to'] : date('Y-m-d')); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Статус</label>
                                            <select name="status" class="form-control selectpicker">
                                                <option value=""><?php echo _l('all'); ?></option>
                                                <option value="Booked_In" <?php echo (isset($filters['status']) && $filters['status'] == 'Booked_In') ? 'selected' : ''; ?>>Забронировано</option>
                                                <option value="In_Progress" <?php echo (isset($filters['status']) && $filters['status'] == 'In_Progress') ? 'selected' : ''; ?>>В работе</option>
                                                <option value="Waiting_For_Parts" <?php echo (isset($filters['status']) && $filters['status'] == 'Waiting_For_Parts') ? 'selected' : ''; ?>>Ожидание запчастей</option>
                                                <option value="Job_Complete" <?php echo (isset($filters['status']) && $filters['status'] == 'Job_Complete') ? 'selected' : ''; ?>>Работа завершена</option>
                                                <option value="Customer_Notified" <?php echo (isset($filters['status']) && $filters['status'] == 'Customer_Notified') ? 'selected' : ''; ?>>Клиент уведомлен</option>
                                                <option value="Finalised" <?php echo (isset($filters['status']) && $filters['status'] == 'Finalised') ? 'selected' : ''; ?>>Завершено</option>
                                                <option value="Cancelled" <?php echo (isset($filters['status']) && $filters['status'] == 'Cancelled') ? 'selected' : ''; ?>>Отменено</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Техника</label>
                                            <select name="device_id" class="form-control selectpicker" data-live-search="true">
                                                <option value=""><?php echo _l('all'); ?></option>
                                                <?php foreach ($devices as $device) { ?>
                                                    <option value="<?php echo $device['id']; ?>"
                                                        <?php echo (isset($filters['device_id']) && $filters['device_id'] == $device['id']) ? 'selected' : ''; ?>>
                                                        <?php echo $device['code'] . ' - ' . $device['name']; ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label><?php echo _l('client'); ?></label>
                                            <select name="client_id" class="form-control selectpicker" data-live-search="true">
                                                <option value=""><?php echo _l('all'); ?></option>
                                                <?php foreach ($clients as $client) { ?>
                                                    <option value="<?php echo $client['userid']; ?>"
                                                        <?php echo (isset($filters['client_id']) && $filters['client_id'] == $client['userid']) ? 'selected' : ''; ?>>
                                                        <?php echo $client['company']; ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <button type="submit" class="btn btn-info">
                                            <i class="fa fa-filter"></i> <?php echo _l('wshop_apply_filter'); ?>
                                        </button>
                                        <a href="<?php echo admin_url('workshop/report_repair_jobs'); ?>" class="btn btn-default">
                                            <i class="fa fa-remove"></i> <?php echo _l('wshop_clear_filter'); ?>
                                        </a>
                                        
                                        <?php if (!empty($jobs)) { ?>
                                            <a href="<?php echo admin_url('workshop/export_repair_jobs_excel?' . http_build_query($filters)); ?>" 
                                               class="btn btn-success pull-right">
                                                <i class="fa fa-file-excel-o"></i> <?php echo _l('wshop_export_excel'); ?>
                                            </a>
                                        <?php } ?>
                                    </div>
                                </div>
                                <?php echo form_close(); ?>
                            </div>
                        </div>

                        <!-- Data Table -->
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>№ Заявки</th>
                                        <th>Дата</th>
                                        <th>Клиент</th>
                                        <th>Техника</th>
                                        <th>Тип работ</th>
                                        <th>Техник</th>
                                        <th class="text-center">Статус</th>
                                        <th class="text-right">Сумма</th>
                                        <th class="text-center">Часов</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($jobs)) { ?>
                                        <?php foreach ($jobs as $job) { 
                                            $status_class = '';
                                            $status_label = '';
                                            switch ($job['status']) {
                                                case 'Booked_In':
                                                    $status_class = 'warning';
                                                    $status_label = 'Забронировано';
                                                    break;
                                                case 'In_Progress':
                                                    $status_class = 'info';
                                                    $status_label = 'В работе';
                                                    break;
                                                case 'Waiting_For_Parts':
                                                    $status_class = 'warning';
                                                    $status_label = 'Ожидание запчастей';
                                                    break;
                                                case 'Job_Complete':
                                                    $status_class = 'success';
                                                    $status_label = 'Работа завершена';
                                                    break;
                                                case 'Customer_Notified':
                                                    $status_class = 'primary';
                                                    $status_label = 'Клиент уведомлен';
                                                    break;
                                                case 'Complete_Awaiting_Finalise':
                                                    $status_class = 'primary';
                                                    $status_label = 'Ожидает завершения';
                                                    break;
                                                case 'Finalised':
                                                    $status_class = 'success';
                                                    $status_label = 'Завершено';
                                                    break;
                                                case 'Cancelled':
                                                    $status_class = 'danger';
                                                    $status_label = 'Отменено';
                                                    break;
                                                case 'Waiting_For_User_Approval':
                                                    $status_class = 'warning';
                                                    $status_label = 'Ожидает одобрения';
                                                    break;
                                                default:
                                                    $status_class = 'default';
                                                    $status_label = $job['status'];
                                            }
                                        ?>
                                        <tr>
                                            <td>
                                                <a href="<?php echo admin_url('workshop/repair_job_detail/' . $job['id'] . '?tab=detail'); ?>">
                                                    <?php echo $job['job_tracking_number']; ?>
                                                </a>
                                            </td>
                                            <td><?php echo _d($job['appointment_date']); ?></td>
                                            <td><?php echo $job['client_name']; ?></td>
                                            <td><?php echo $job['device_code'] . ' - ' . $job['device_name']; ?></td>
                                            <td><?php echo $job['appointment_type']; ?></td>
                                            <td><?php echo $job['technician_name']; ?></td>
                                            <td class="text-center">
                                                <span class="label label-<?php echo $status_class; ?>">
                                                    <?php echo $status_label; ?>
                                                </span>
                                            </td>
                                            <td class="text-right"><?php echo app_format_money($job['total'], ''); ?></td>
                                            <td class="text-center"><?php echo number_format($job['estimated_hours'], 1); ?></td>
                                        </tr>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr>
                                            <td colspan="9" class="text-center">Нет данных</td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
